package doABC;

import java.nio.ByteBuffer;
import java.util.*;
import FlashReader.*;

public class ItemInfo extends SwfTools{
	
	private CpoolInfo cpool;
	private int start;
	private int end;
	//struktury
	private int key;
	private int value;
	
	
	
	public ItemInfo(ByteBuffer bbuf,  CpoolInfo cpool){
		super();
		this.cpool = cpool;
		item_info(bbuf);
	}
	
	private void item_info(ByteBuffer bbuf){
		start = bbuf.position();
		key = unsigned30int(bbuf);
		value = unsigned30int(bbuf);
		end=bbuf.position()-1;

	}
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
			
			for ( byte b: getUI32(key))
				result.add(b);
		
			for ( byte b: getUI32(value))
				result.add(b);

		return result;
	}
	
	//getters
	
	public int getStart() {
		return start;
	}

	public int getEnd() {
		return end;
	}

	public int getKey() {
		return key;
	}

	public int getValue() {
		return value;
	}
	
	public String getKey_string() {
		return cpool.getString(key);
	}
	
	public String getValue_string() {
		return cpool.getString(value);
	}
	
	//tostrings
	
	public String String(){
		StringBuffer wynik = new StringBuffer();
		
		wynik.append( "\n---#--- option_info "+SWF.msgs.getString("Position")+": " + start + "\n\n" );
		
		wynik.append( "key: " + key+"\n" );
			
		wynik.append( "value: " + value+"\n" );
			
		wynik.append( "\n---!!--- "+SWF.msgs.getString("Position")+":  "+end );
		
		return wynik.toString();	
	}
	
	public String toString(){
		String wynik ="";
		wynik+=start+ " - " + end;
		return wynik;
	}

}
